function delta_mtrx = delta(stk,varargin)
%An utility that takes an image stack matrix and figures out the per pixel
%baseline of the stack and the computes the per pixel change over the
%baseline of each frame.
%Syntax: delta_mtrx=delta(stk,percent,range_extend);
%Input:  stk = the image stack, the basic unit of all my image processing.
%        percent = the percent of the lowest points used to calculat the
%        baseline.  Default = 10%
%        range_extend = 'on'/'off', Default='off'
%Output: delta_mtrx = the change matrix is a 2d array that represents the
%        maximal change per pixel of the image through the stack.  The
%        Output is a double array.

rex = 'off';

if isempty(varargin)             %Set Defaults
    percent = 0.1;
else
    b = size(varargin);
    for i = 1:b(1,2)
        if isnumeric(varargin{1,i})
            percent = varargin{1,i}/100;
        end
        if ischar(varargin{1,i})
            if strcmp(varargin{1,i},'on')
                rex = 'on';
                if b(1,2)<2
                    percent = 0.1;  %percent is not specified, go to default
                end
            end
        end
    end            
end

a = size(stk,3);          %Size up the stack
delta_mtrx = zeros(size(stk),'uint8'); %initialize change matrix

if a>1  %matrix not array
    sorted_stk = sort(stk,3,'ascend');  %Sort the values of the stack so that the lowest is on top (:,:,1)
end
base_mtrx = uint8(mean(sorted_stk(:,:,1:ceil(a(1,3)*percent)),3));  %The baseline matrix is the mean of the lowest 10% of values

switch rex
    case 'off'
        for i = 1:a
            delta_mtrx(:,:,i) = stk(:,:,i)-base_mtrx;   %The base_mtrx is used calculate the change per frame.
        end
    case 'on'
        for i = 1:a
            delta_mtrx(:,:,i) = stk(:,:,i)-base_mtrx;   %The base_mtrx is used calculate the change per frame.
            delta_mtrx(:,:,i) = rangemax(delta_mtrx(:,:,i),256,max(max(max(stk))));
        end
end
